<?php
/**
 * Clase controlador encargada de la gestion de las puntuaciones de los combates creados.
 * Created by PhpStorm.
 * User: Pablo García Sanz
 * Date: 23/01/2018
 * Time: 18:52
 */

class Score extends CI_Controller {
    /**
     * Constructor de la clase Score. Comprueba que existe session activa de un usuario con rol de cronometrador
     * o con rol de delegado
     * Score constructor.
     */
    function __construct()
    {
        parent::__construct();
        if (!$this->session->has_userdata('user') && ! $this -> session -> has_userdata('timekeeper'))
            redirect(base_url() . '?msg=' . SESSION_EXPIRED, 'refresh');
        include 'application/src/Pagination.php';
        $this->language = $this->session->userdata('language');
        $this -> load -> library('pagination');
        $this -> load -> model ('combatModel');



    }

    /**
     * Añadir una puntuacion con el rol de delegado
     * @param $idCombat del que se quiere introducir la puntuacion
     */
    public function addScore($idCombat) {
        $idCompetition = $this -> input -> post('idCompetition');
        $idWeight = $this -> input -> post('idWeight');

        $ippon_white = $this -> input ->post('ippon_white');
        $wazari_white = $this -> input -> post('wazari_white');
        $shido_white = $this -> input -> post('shido_white');
        $hansoku_white = $this -> input -> post('hansoku_white');

        $ippon_blue = $this -> input ->post('ippon_blue');
        $wazari_blue = $this -> input -> post('wazari_blue');
        $shido_blue = $this -> input -> post('shido_blue');
        $hansoku_blue = $this -> input -> post('hansoku_blue');

        $dniWhite =  $this -> input -> post('dniWhite');
        $dniBlue =  $this -> input -> post('dniBlue');
        try {
            $this -> combatModel -> addScore($dniWhite,$ippon_white,$wazari_white,$shido_white,$hansoku_white, $idCombat);
            $this -> combatModel -> addScore($dniBlue,$ippon_blue,$wazari_blue,$shido_blue,$hansoku_blue, $idCombat);
            redirect(base_url().'competition/viewcombats/'.$idCompetition.'?idWeight='.$idWeight.'&msg='.SUCCESS_ADD_SCORE);
        }
        catch (Exception $e) {

        }



    }
    /**
     * Añadir una puntuacion con el rol de cronometrador
     * @param $idCombat del que se quiere introducir la puntuacion
     */
    public function addScoreTimekeeper($idCombat) {

        $idMat = $this -> input -> post ('idMat');

        $ippon_white = $this -> input ->post('ippon_white');
        $wazari_white = $this -> input -> post('wazari_white');
        $shido_white = $this -> input -> post('shido_white');
        $hansoku_white = $this -> input -> post('hansoku_white');

        $ippon_blue = $this -> input ->post('ippon_blue');
        $wazari_blue = $this -> input -> post('wazari_blue');
        $shido_blue = $this -> input -> post('shido_blue');
        $hansoku_blue = $this -> input -> post('hansoku_blue');

        $dniWhite =  $this -> input -> post('dniWhite');
        $dniBlue =  $this -> input -> post('dniBlue');
        try {
            $this -> combatModel -> addScore($dniWhite,$ippon_white,$wazari_white,$shido_white,$hansoku_white, $idCombat);
            $this -> combatModel -> addScore($dniBlue,$ippon_blue,$wazari_blue,$shido_blue,$hansoku_blue, $idCombat);
            redirect(base_url().'timekeeper/mat/'.$idMat.'?msg='.SUCCESS_ADD_SCORE);
        }
        catch (Exception $e) {

        }



    }
}